<?php
session_start();

// যদি ইউজার লগইন না থাকে বা এডমিন না হয়
if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 'admin') {
    header("Location: login.php");
    exit;
}

// ডেটাবেস সংযোগ
$conn = new mysqli('localhost', 'root', '', 'ledger_db');
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// গ্রাহকের account_number ফেচ করা
$account_number = isset($_GET['account_number']) ? $_GET['account_number'] : '';  // একাউন্ট নাম্বার

// লেনদেন ফিল্টারিং (যদি কিছু পাঠানো হয়)
$transaction_type = isset($_GET['transaction_type']) ? $_GET['transaction_type'] : '';  // ফিল্টার করা ট্রানজেকশন টাইপ
$start_date = isset($_GET['start_date']) ? $_GET['start_date'] : '';
$end_date = isset($_GET['end_date']) ? $_GET['end_date'] : '';

// SQL কোয়েরি
$sql = "SELECT t.id, t.account_number, t.transaction_type, t.amount, t.date, t.cheque, t.description, t.balance
        FROM transactions t
        WHERE t.account_number = ?";

// যদি ট্রানজেকশন টাইপ ফিল্টার করা হয়
if ($transaction_type) {
    $sql .= " AND t.transaction_type = ?";
}

// যদি তারিখ ফিল্টার করা হয়
if ($start_date && $end_date) {
    $sql .= " AND t.date BETWEEN ? AND ?";
}

$stmt = $conn->prepare($sql);

// যদি তারিখ এবং ট্রানজেকশন টাইপ ফিল্টার করা হয়
if ($transaction_type && $start_date && $end_date) {
    $stmt->bind_param("ssss", $account_number, $transaction_type, $start_date, $end_date);
} elseif ($transaction_type) {
    $stmt->bind_param("ss", $account_number, $transaction_type); // শুধু ট্রানজেকশন টাইপ ফিল্টার
} elseif ($start_date && $end_date) {
    $stmt->bind_param("sss", $account_number, $start_date, $end_date); // শুধু তারিখ ফিল্টার
} else {
    $stmt->bind_param("s", $account_number); // কোন ফিল্টার ছাড়াই
}

$stmt->execute();
$result = $stmt->get_result();

// ডিবাগিং: ট্রানজেকশন রেজাল্ট চেক করা
// echo "Number of transactions found: " . $result->num_rows . "<br>";  // চেক করুন যে রেজাল্ট আসছে কি না

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Transactions</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f4f7fc;
            margin: 0;
            padding: 0;
        }

        .container {
            width: 90%;
            margin: 50px auto;
            display: flex;
            justify-content: space-between;
        }

        /* Sidebar */
        .sidebar {
            width: 30%;
            background-color: #f9f9f9;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .sidebar h3 {
            color: #4a90e2;
        }

        .sidebar p {
            font-size: 14px;
            margin-bottom: 10px;
        }

        /* Transactions Table */
        .transactions-table {
            width: 65%;
            background-color: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        table {
            width: 100%;
            margin-top: 30px;
            border-collapse: collapse;
        }

        table, th, td {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: center;
        }

        th {
            background-color: #4a90e2;
            color: white;
        }

        tr:hover {
            background-color: #f1f1f1;
        }

        .header {
            display: flex;
            justify-content: space-between;
            background-color: #4a90e2;
            color: white;
            padding: 10px 20px;
            border-radius: 5px;
            margin-bottom: 20px;
        }

        .logout-btn {
            background-color: #fff;
            color: #4a90e2;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s;
        }

        .logout-btn:hover {
            background-color: #357ab7;
            color: white;
        }

        .filter-form {
            margin: 20px 0;
        }

        .filter-form select, .filter-form input {
            padding: 10px;
            border-radius: 5px;
            border: 1px solid #ccc;
        }

        .filter-form button {
            padding: 10px 20px;
            border-radius: 5px;
            background-color: #4a90e2;
            color: white;
            border: none;
            cursor: pointer;
            font-size: 16px;
        }

        .filter-form button:hover {
            background-color: #357ab7;
        }
    </style>
</head>
<body>

    <div class="container">
        <!-- Sidebar Section with user details -->
        <div class="sidebar">
            <h3>Filter by Account Number</h3>
            <form method="GET" action="aview_transaction.php">
                <input type="text" name="account_number" placeholder="Enter Account Number" required>
                <button type="submit">Search</button>
            </form>
        </div>

        <!-- Transactions Table Section -->
        <div class="transactions-table">
            <div class="header">
                <h1>Transactions for Account Number: <?php echo $account_number; ?></h1>
                <form method="POST" style="display:inline;">
                    <button type="submit" name="logout" class="logout-btn">Logout</button>
                </form>
            </div>

            <!-- Filter Section -->
            <div class="filter-form">
                <form method="GET" action="aview_transaction.php">
                    <label for="transaction_type">Filter by Transaction Type:</label>
                    <select name="transaction_type" id="transaction_type">
                        <option value="">All</option>
                        <option value="deposit" <?php echo $transaction_type == 'deposit' ? 'selected' : ''; ?>>Deposit</option>
                        <option value="withdraw" <?php echo $transaction_type == 'withdraw' ? 'selected' : ''; ?>>Withdraw</option>
                    </select>

                    <label for="start_date">Start Date:</label>
                    <input type="date" name="start_date" id="start_date" value="<?php echo $start_date; ?>">

                    <label for="end_date">End Date:</label>
                    <input type="date" name="end_date" id="end_date" value="<?php echo $end_date; ?>">

                    <button type="submit">Filter</button>
                </form>
            </div>

            <!-- Transactions Table -->
            <?php if ($result->num_rows > 0): ?>
                <table>
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Cheque</th>
                            <th>Description</th>
                            <th>Withdraw</th>
                            <th>Deposit</th>
                            <th>Balance</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $balance = 0;
                        while ($row = $result->fetch_assoc()):
                            // Balance calculation based on transaction type
                            if ($row['transaction_type'] == 'deposit') {
                                $balance += $row['amount'];
                            } elseif ($row['transaction_type'] == 'withdraw') {
                                $balance -= $row['amount'];
                            }
                        ?>
                            <tr>
                                <td><?php echo $row['date']; ?></td>
                                <td><?php echo $row['cheque']; ?></td>
                                <td><?php echo $row['description']; ?></td>
                                <td><?php echo ($row['transaction_type'] == 'withdraw') ? number_format($row['amount'], 2) : '0.00'; ?></td>
                                <td><?php echo ($row['transaction_type'] == 'deposit') ? number_format($row['amount'], 2) : '0.00'; ?></td>
                                <td><?php echo number_format($balance, 2); ?></td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p>No transactions found.</p>
            <?php endif; ?>

            <!-- Back to Dashboard Link -->
            <a href="dashboard.php" class="logout-btn">Back to Dashboard</a>

        </div>
    </div>

</body>
</html>
