<?php
session_start();

// যদি ইউজার লগইন না থাকে বা এডমিন না হয়
if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 'admin') {
    header("Location: login.php");
    exit;
}

// ডেটাবেস সংযোগ
$conn = new mysqli('localhost', 'root', '', 'ledger_db');
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// ইউজারের তথ্য সংগ্রহ
$user_id = $_SESSION['user_id'];
$sql = "SELECT * FROM users WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

// যদি ইউজার পাওয়া না যায়, তাহলে লগ আউট করে দিবে
if ($result->num_rows == 0) {
    session_unset();
    session_destroy();
    header("Location: login.php");
    exit;
}

$user_data = $result->fetch_assoc();

// মোট ডিপোজিট এবং উইথড্র সংক্রান্ত ডেটা সংগ্রহ
$sql_deposit = "SELECT SUM(amount) AS total_deposit FROM transactions WHERE transaction_type = 'deposit'";
$result_deposit = $conn->query($sql_deposit);
$total_deposit = $result_deposit->fetch_assoc()['total_deposit'];

$sql_withdraw = "SELECT SUM(amount) AS total_withdraw FROM transactions WHERE transaction_type = 'withdraw'";
$result_withdraw = $conn->query($sql_withdraw);
$total_withdraw = $result_withdraw->fetch_assoc()['total_withdraw'];

// সর্বশেষ লেনদেন
$sql_last_transaction = "SELECT * FROM transactions ORDER BY date DESC LIMIT 1";
$result_last_transaction = $conn->query($sql_last_transaction);
$last_transaction = $result_last_transaction->fetch_assoc();

// মোট গ্রাহক সংখ্যা
$sql_users = "SELECT COUNT(*) AS total_users FROM users";
$result_users = $conn->query($sql_users);
$total_users = $result_users->fetch_assoc()['total_users'];

// আজকের ডিপোজিট এবং উইথড্র এর ডেটা সংগ্রহ
$today = date('Y-m-d');
$sql_today_deposit = "SELECT SUM(amount) AS today_deposit FROM transactions WHERE transaction_type = 'deposit' AND DATE(date) = ?";
$result_today_deposit = $conn->prepare($sql_today_deposit);
$result_today_deposit->bind_param("s", $today);
$result_today_deposit->execute();
$today_deposit = $result_today_deposit->get_result()->fetch_assoc()['today_deposit'];

$sql_today_withdraw = "SELECT SUM(amount) AS today_withdraw FROM transactions WHERE transaction_type = 'withdraw' AND DATE(date) = ?";
$result_today_withdraw = $conn->prepare($sql_today_withdraw);
$result_today_withdraw->bind_param("s", $today);
$result_today_withdraw->execute();
$today_withdraw = $result_today_withdraw->get_result()->fetch_assoc()['today_withdraw'];

// Default values if no data found
if (is_null($today_deposit)) {
    $today_deposit = 0;
}
if (is_null($today_withdraw)) {
    $today_withdraw = 0;
}

// ১০টি একাউন্টের লেনদেন তথ্য সংগ্রহ (Updated Query for Top 10 Transactions)
$sql_transactions = "SELECT t.account_number, u.username, t.date, t.amount, t.transaction_type, t.description
                    FROM transactions t 
                    JOIN users u ON t.account_number = u.account_number 
                    ORDER BY t.amount DESC
                    LIMIT 10";
$result_transactions = $conn->query($sql_transactions);

$conn->close();

// লগ আউট করার কোড
if (isset($_POST['logout'])) {
    session_unset();
    session_destroy();
    header("Location: login.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <style>
        /* Base Styles */
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f9f9f9;
            margin: 0;
            padding: 0;
            color: #333;
        }

        /* Sidebar */
        .sidebar {
            width: 250px;
            background-color: #2c3e50;
            color: #fff;
            height: 100vh;
            position: fixed;
            top: 0;
            left: 0;
            padding-top: 30px;
        }
        .sidebar a {
            color: #fff;
            text-decoration: none;
            display: block;
            padding: 15px;
            margin: 10px 0;
            border-radius: 5px;
            transition: background-color 0.3s;
        }
        .sidebar a:hover {
            background-color: #34495e;
        }

        /* Main Content */
        .main-content {
            margin-left: 260px;
            padding: 30px;
        }

        /* Header */
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background-color: #4a90e2;
            color: white;
            padding: 15px;
            border-radius: 5px;
        }

        .header h1 {
            margin: 0;
        }

        .header button {
            background-color: #fff;
            color: #4a90e2;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s;
        }

        .header button:hover {
            background-color: #357ab7;
            color: white;
        }

        /* Chart Section */
        .chart-container {
            background-color: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            margin-top: 30px;
        }

        .chart-container h2 {
            text-align: center;
            color: #4a90e2;
        }

        .statistics {
            display: flex;
            justify-content: space-between;
            margin-top: 30px;
        }

        .stat {
            background-color: #fff;
            width: 30%;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            text-align: center;
        }

        .stat h3 {
            margin: 0;
            font-size: 24px;
            color: #4a90e2;
        }

        .stat p {
            font-size: 18px;
            color: #555;
        }

        /* New section for showing the top 10 transactions */
        .top-transactions-container {
            margin-top: 30px;
            background-color: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .top-transactions-container h2 {
            text-align: center;
            color: #4a90e2;
        }

        table {
            width: 100%;
            margin-top: 20px;
            border-collapse: collapse;
        }

        table, th, td {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: center;
        }

        th {
            background-color: #4a90e2;
            color: white;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }
		footer {
            background-color: #4a90e2;
            color: white;
            text-align: center;
            padding: 10px;
            position: fixed;
            bottom: 0;
            width: 100%;
            font-size: 14px;
        }
    </style>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>

    <!-- Sidebar -->
    <div class="sidebar">
        <a href="dashboard.php">Dashboard</a>
        <a href="add_customer.php">Add Customer</a>
        <a href="add_transaction.php">Add Transaction</a>
        <a href="view_customers.php">View Customers</a>
        <a href="aview_transaction.php">View Transactions</a>
		<a href="allview_transactions.php">View All Transactions</a> <!-- New Link for View All Transactions -->
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Header -->
        <div class="header">
            <h1>Welcome to the Admin Dashboard</h1>
            <div>
                <span style="color: white; margin-right: 20px;">Logged in as: <?php echo $user_data['account_number']; ?></span>
                <!-- Logout Button -->
                <form method="POST" style="display:inline;">
                    <button type="submit" name="logout">Logout</button>
                </form>
            </div>
        </div>

        <!-- Statistics Section -->
        <div class="statistics">
            <div class="stat">
                <h3>Total Deposit</h3>
                <p>BDT <?php echo number_format($total_deposit); ?></p>
            </div>
            <div class="stat">
                <h3>Total Withdraw</h3>
                <p>BDT <?php echo number_format($total_withdraw); ?></p>
            </div>
            <div class="stat">
                <h3>Active Users</h3>
                <p><?php echo $total_users; ?></p>
            </div>
        </div>

        <!-- Top 10 Transactions Section -->
        <div class="top-transactions-container">
            <h2>Top 10 Accounts by Transaction Amount</h2>
            <table>
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Name</th>
                        <th>Account Number</th>
                        <th>Transaction Amount (BDT)</th>
                        <th>Transaction Type</th>
                        <th>Description</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($result_transactions->num_rows > 0) {
                        while ($row = $result_transactions->fetch_assoc()) { ?>
                            <tr>
                                <td><?php echo $row['date']; ?></td>
                                <td><?php echo $row['username']; ?></td>
                                <td><?php echo $row['account_number']; ?></td>
                                <td>BDT <?php echo number_format($row['amount']); ?></td>
                                <td><?php echo $row['transaction_type']; ?></td>
                                <td><?php echo $row['description']; ?></td>
                            </tr>
                    <?php }
                    } else {
                        echo "<tr><td colspan='6' class='text-center'>No transactions found</td></tr>";
                    } ?>
                </tbody>
            </table>
        </div>

        <!-- Today's Deposit and Withdraw Section (Flow Chart like representation) -->
        <div class="chart-container">
            <h2>Today's Deposit and Withdraw</h2>
            <canvas id="todayTransactionsChart"></canvas>
        </div>
    </div>

    <script>
        // Chart.js - Today's Deposit and Withdraw Chart (Flow-like representation)
        const ctx = document.getElementById('todayTransactionsChart').getContext('2d');
        const todayTransactionsChart = new Chart(ctx, {
            type: 'bar',
            data: {
                labels: ['Deposit', 'Withdraw'],
                datasets: [{
                    label: 'Amount (TK)',
                    data: [<?php echo $today_deposit; ?>, <?php echo $today_withdraw; ?>], // PHP variables dynamically
                    backgroundColor: ['#4caf50', '#ff5733'],
                    borderColor: ['#4caf50', '#ff5733'],
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                scales: {
                    y: {
                        beginAtZero: true
                    }
                },
                plugins: {
                    legend: {
                        position: 'top'
                    }
                }
            }
        });
    </script>
<footer>
        <p>Developed By Nesar A Nishan - V.1.0.1 </p>
    </footer>
</body>
</html>
