<?php
session_start();

// ডেটাবেস সংযোগ
$conn = new mysqli('localhost', 'root', '', 'ledger_db');
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// ডিলিট ফাংশন
if (isset($_GET['delete_id'])) {
    $delete_id = $_GET['delete_id'];
    $sql_delete = "DELETE FROM users WHERE id = ?";
    $stmt_delete = $conn->prepare($sql_delete);
    $stmt_delete->bind_param("i", $delete_id);
    if ($stmt_delete->execute()) {
        echo "<script>alert('Customer deleted successfully!'); window.location.href = 'view_customers.php';</script>";
    } else {
        echo "Error deleting customer: " . $conn->error;
    }
}

// ইউজারদের তথ্য দেখানো
$sql = "SELECT * FROM users WHERE role = 'customer'";
$result = $conn->query($sql);

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Customers</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #1e90ff, #ff7f50); /* Beautiful gradient colors */
            min-height: 100vh;
        }

        .container {
            margin-top: 50px;
        }

        .card {
            background-color: rgba(255, 255, 255, 0.9);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.1);
        }

        .table th {
            background-color: #ff7f50;
            color: white;
        }

        .table-striped tbody tr:nth-child(odd) {
            background-color: rgba(0, 0, 0, 0.05);
        }

        .btn {
            transition: background-color 0.3s ease;
        }

        .btn-warning:hover, .btn-danger:hover {
            background-color: #e67e22;
            color: white;
        }

        .btn-secondary {
            transition: background-color 0.3s ease;
        }

        .btn-secondary:hover {
            background-color: #357ab7;
            color: white;
        }

        .back-btn {
            position: fixed;
            bottom: 20px;
            left: 50%;
            transform: translateX(-50%);
            padding: 10px 30px;
            background-color: #28a745;
            color: white;
            font-size: 16px;
            border-radius: 30px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.2);
            transition: background-color 0.3s ease;
        }

        .back-btn:hover {
            background-color: #218838;
        }
    </style>
</head>
<body>

    <div class="container">
        <div class="card">
            <div class="card-header bg-primary text-white text-center">
                <h3>Customer List</h3>
            </div>

            <div class="card-body">
                <!-- Table to display customers -->
                <table class="table table-striped table-bordered">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Account Number</th>
                            <th>Address</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($result->num_rows > 0) {
                            while ($row = $result->fetch_assoc()) { ?>
                                <tr>
                                    <td><?php echo $row['id']; ?></td>
                                    <td><?php echo $row['username']; ?></td>
                                    <td><?php echo $row['account_number']; ?></td>
                                    <td><?php echo $row['address']; ?></td>
                                    <td>
                                        <!-- Edit Button -->
                                        <a href="edit_customer.php?id=<?php echo $row['id']; ?>" class="btn btn-warning btn-sm">Edit</a>

                                        <!-- Delete Button -->
                                        <a href="?delete_id=<?php echo $row['id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this customer?')">Delete</a>
                                    </td>
                                </tr>
                        <?php }
                        } else {
                            echo "<tr><td colspan='5' class='text-center'>No customers found</td></tr>";
                        } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Back to Dashboard Button (at the bottom) -->
    <a href="dashboard.php" class="back-btn">Back to Dashboard</a>

    <!-- Bootstrap 5 JS and dependencies -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
